package gov.va.med.mhv.rxrefill.data.model;

import java.io.Serializable;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;

@Entity
@Table(name = "FUNCTIONS")
public class Function implements Serializable {

	private static final long serialVersionUID = -9189771030474287792L;

	@Id
	@Column(name = "FUNCTION_ID_SEQ")
	@GeneratedValue(strategy = GenerationType.AUTO)
	private Long id;

	@Column(name = "FUNCTION_NAME")
	private String functionName;

	@Column(name = "ENCODER")
	private String encoder;

	@Column(name = "DECODER")
	private String decoder;

	@Column(name = "ASYNC_DECODER")
	private String asyncDecoder;

	@Column(name = "ASYNC_HANDLER")
	private String asyncHandler;
	
	@Column(name = "AA_ENCODER")
	private String aaEncoder;
	
	@Column(name = "CATEGORY_CODE", insertable = false, updatable = false)
	private String categoryCode;

	@ManyToOne(fetch = FetchType.EAGER)
	@JoinColumn(name = "CATEGORY_CODE")
	private CategoryType categoryType;

	@Column(name = "REQUESTS_PER_DAY")
	private Integer requestsPerDay;
	
	@Column(name = "RESPONSE_WAIT_TIME")
	private Integer responseWaitTime;
	
	@Column(name = "CONSECUTIVE_FAILED_PER_DAY")
	private Integer consecutiveFailedPerDay;
	
	public Long getId() {
		return id;
	}

	public void setId(Long id) {
		this.id = id;
	}

	public String getFunctionName() {
		return functionName;
	}

	public void setFunctionName(String functionName) {
		this.functionName = functionName;
	}

	public String getEncoder() {
		return encoder;
	}

	public void setEncoder(String encoder) {
		this.encoder = encoder;
	}

	public String getDecoder() {
		return decoder;
	}

	public void setDecoder(String decoder) {
		this.decoder = decoder;
	}

	public String getAsyncDecoder() {
		return asyncDecoder;
	}

	public void setAsyncDecoder(String asyncDecoder) {
		this.asyncDecoder = asyncDecoder;
	}

	public String getAsyncHandler() {
		return asyncHandler;
	}

	public void setAsyncHandler(String asyncHandler) {
		this.asyncHandler = asyncHandler;
	}

	public String getAaEncoder() {
		return aaEncoder;
	}

	public void setAaEncoder(String aaEncoder) {
		this.aaEncoder = aaEncoder;
	}

	public String getCategoryCode() {
		return categoryCode;
	}

	public void setCategoryCode(String categoryCode) {
		this.categoryCode = categoryCode;
	}

	public Integer getRequestsPerDay() {
		return requestsPerDay;
	}

	public void setRequestsPerDay(Integer requestsPerDay) {
		this.requestsPerDay = requestsPerDay;
	}

	public Integer getResponseWaitTime() {
		return responseWaitTime;
	}

	public void setResponseWaitTime(Integer responseWaitTime) {
		this.responseWaitTime = responseWaitTime;
	}

	public Integer getConsecutiveFailedPerDay() {
		return consecutiveFailedPerDay;
	}

	public void setConsecutiveFailedPerDay(Integer consecutiveFailedPerDay) {
		this.consecutiveFailedPerDay = consecutiveFailedPerDay;
	}

	public CategoryType getCategoryType() {
		return categoryType;
	}

	public void setCategoryType(CategoryType categoryType) {
		this.categoryType = categoryType;
	}
}
